return {
  "nvim-neo-tree/neo-tree.nvim",
  branch = "v3.x",
  dependencies = {
    "nvim-lua/plenary.nvim",
    "nvim-tree/nvim-web-devicons",
    "MunifTanjim/nui.nvim",
  },
  cmd = "Neotree",
  keys = {
    { "<leader>e", "<cmd>Neotree toggle<CR>", desc = "Toggle Explorer" },
  },
  config = function()
    local neotree = require("neo-tree")

    neotree.setup({
      filesystem = {
        filtered_items = {
          hide_dotfiles = false,
          hide_gitignored = false,
        },
      },
      window = {
        mappings = {
          ["P"] = "toggle_preview",  -- Shift+P — вручную открыть/закрыть preview
          ["l"] = "open",
          ["s"] = "open_split",
          ["v"] = "open_vsplit",
        },
      },
    })

    ------------------------------------------------------------------
    -- 🪄 Автоматическое превью при наведении на файл в Neo-tree
    ------------------------------------------------------------------
    vim.api.nvim_create_autocmd("BufEnter", {
      pattern = "neo-tree filesystem [1]*",
      callback = function()
        local events = require("neo-tree.events")
        local manager = require("neo-tree.sources.manager")
        local fs = manager.get_state("filesystem")

        if fs and not fs._preview_listener then
          fs._preview_listener = true

          fs:event_handler("file_opened", function()
            vim.cmd("pclose") -- закрыть preview при открытии файла
          end)

          fs:event_handler("cursor_moved", function()
            local node = fs.tree:get_node()
            if node and not node.type:match("directory") then
              require("neo-tree.sources.filesystem.commands").show_file_preview(fs)
            end
          end)
        end
      end,
    })
  end,
}
